/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import panther.util.unicon.TimeoutException;

public abstract class SynchronizedCollection {
    private int maxSize = 0;
    private long maxWaitTime = 0L;

    public synchronized void add(Object object) {
        if (object == null) {
            return;
        }
        if (this.maxSize > 0 && this.getQueue().size() >= this.maxSize) {
            throw new RuntimeException("Attempting to add object to a full collection");
        }
        this.getQueue().add(object);
        this.notify();
    }

    public synchronized List contents() {
        ArrayList arrayList = new ArrayList(this.getQueue());
        return arrayList;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean guaranteedAdd(Object object, int n) {
        if (n < 0) {
            return false;
        }
        boolean bl = false;
        try {
            this.add(object);
            bl = true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
        }
        finally {
            if (!bl) {
                bl = this.guaranteedAdd(object, n - 1);
            }
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.getQueue().isEmpty();
    }

    public Object next() throws TimeoutException, InterruptedException {
        return this.next(this.maxWaitTime);
    }

    protected synchronized Object next(long l) throws TimeoutException, InterruptedException {
        long l2 = 0L;
        long l3 = 0L;
        if (this.isEmpty()) {
            l2 = System.currentTimeMillis();
            this.wait(l);
            l3 = System.currentTimeMillis();
        }
        if (this.isEmpty()) {
            long l4 = l - (l3 - l2);
            if (l4 > 0L) {
                return this.next(l4);
            }
            throw new TimeoutException("timeout");
        }
        return this.getNext();
    }

    public synchronized Object nextNoWait() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getNext();
    }

    public synchronized boolean remove(Object object) {
        return this.getQueue().remove(object);
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public synchronized int size() {
        return this.getQueue().size();
    }

    protected long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    protected abstract Object getNext();

    protected abstract Collection getQueue();

    protected void setMaxWaitTime(long l) {
        this.maxWaitTime = l;
    }
}

